/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8260;

import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.modelgen.ContextSwitcher;
import ibm.nways.jdm.modelgen.InstrumentationContext;
import ibm.nways.jdm.modelgen.LocalModel;
import ibm.nways.jdm.modelgen.SnmpInstrContext;
import ibm.nways.jdm.snmp.DerivedSession;
import ibm.nways.jdm.snmp.SnmpSession;
import ibm.nways.ras.RAS;
import java.io.Serializable;

public final class CpswContextSwitcher
implements ContextSwitcher {
    public final InstrumentationContext createNewContext(InstrumentationContext instrumentationContext, LocalModel localModel, Serializable[] serializableArray) {
        String string = "createNewContext";
        try {
            LocalModel localModel2 = localModel.getTopLevel();
            LocalModel localModel3 = localModel2.getComponent("CpswInfo");
            if (localModel3 == null) {
                return instrumentationContext;
            }
            String string2 = null;
            string2 = CpswContextSwitcher.lookForCPSWInSlot(localModel3, 9);
            if (string2 == null) {
                string2 = CpswContextSwitcher.lookForCPSWInSlot(localModel3, 11);
            }
            if (string2 == null) {
                return instrumentationContext;
            }
            if ("0.0.0.0".equals(string2)) {
                return instrumentationContext;
            }
            if (RAS.isEnabled(4, 2)) {
                RAS.trace(4, 2, this, string, "IP Address for CP/SW -> " + string2);
            }
            SnmpSession snmpSession = ((SnmpInstrContext)instrumentationContext).getSession();
            DerivedSession derivedSession = new DerivedSession(snmpSession, "", "");
            derivedSession.setAddress(string2);
            return new SnmpInstrContext((SnmpSession)derivedSession);
        }
        catch (Exception exception) {
            RAS.logException(4, 2, this, string, exception);
            return instrumentationContext;
        }
    }

    public static final String lookForCPSWInSlot(LocalModel localModel, int n) {
        if (localModel == null) {
            return null;
        }
        ModelInfo modelInfo = new ModelInfo();
        modelInfo.add("Index.SlotIndex", new Integer(n));
        modelInfo.add("Index.SubSlotIndex", new Integer(1));
        ModelInfo modelInfo2 = localModel.getInfo("Panel", "default", modelInfo);
        if (modelInfo2 == null) {
            return null;
        }
        Serializable serializable = modelInfo2.get("Panel.ModType");
        if (serializable instanceof SpecialValue) {
            return null;
        }
        int n2 = (Integer)serializable;
        switch (n2) {
            case 77: {
                Serializable serializable2 = modelInfo2.get("Panel.RedundancyMode");
                if (serializable2 instanceof SpecialValue) {
                    return null;
                }
                if ((Integer)serializable2 != 1) break;
                Serializable serializable3 = modelInfo2.get("Panel.IPAddress");
                return serializable3.toString();
            }
            case 168: {
                Serializable serializable4 = modelInfo2.get("Panel.RedundancyMode8265");
                if ((Integer)serializable4 != 1) break;
                Serializable serializable5 = modelInfo2.get("Panel.IPAddress");
                return serializable5.toString();
            }
        }
        return null;
    }
}

